<?php

namespace App\Http\Controllers;

use App\Banner;
use App\Newsletter;
use App\Tips;
use http\Client\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;

class APIController extends Controller
{
    public function getBanners(){
        $banners = Banner::all();
        return Response()->json(['error' => 'false', 'banners' => $banners]);
    }

    public function getTips($contient_id){
        $tips = Tips::where('continent_id',$contient_id)->get();
        return Response()->json(['error' => 'false', 'tips' => $tips]);
    }

    public function getDetailTip($id){
        $tips = Tips::where('id',$id)->get();
        return Response()->json(['error' => 'false', 'tip' => $tips]);
    }

    public function saveNewsletter(){
        $email = Input::get('email');
        $news = new Newsletter();
        $news->email = $email;
        try{
            $news->save();
            return Response()->json(['error' => 'false', 'message' => 'Se ha registrado tu correo a nuestro newsletter']);
        }catch (\Exception $ex){
            return Response()->json(['error' => 'true', 'message' => $ex->getMessage()]);
        }
    }
}
