<?php

namespace App\Http\Controllers;

use App\Category;
use App\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Session;
use Redirect;

class PackageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       // $packs = Package::all();
        $packs = Package::with('category')->get();
        return view('packs.index', compact('packs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $isNew = true;
        $categories = Category::pluck('name','id');
        return view('packs.create',compact('categories', 'isNew'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = $request->validate([
            'title' => 'required',
            'image' => 'required',
            'detail_image' => 'required',
            'description' => 'required',
            'category' => 'required'
        ]);

        if(Input::hasFile('image')) {
            $this->validate($request, ['image' => 'mimes:jpeg,jpg,png',]);
            $this->validate($request, ['detail_image' => 'mimes:jpeg,jpg,png',]);

            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "pack" . "." . $ext;

            $file_logo2 = Input::file('detail_image');
            $ext = $file_logo2->getClientOriginalExtension();
            $fileLogo2 = time() . "__" . "pack" . "." . $ext;

            $pack = new Package();
            $pack->title = $request['title'];
            $pack->from = $request['from'];
            $pack->description = $request['description'];
            $pack->duration = $request['duration'];
            $pack->cities = $request['cities'];
            $pack->category_id = $request['category'];
            $pack->pack_status = 1;
            $pack->image = 'images/packs/'.$fileLogo;
            $pack->detail_image = 'images/packs/'.$fileLogo2;
            $pack->save();

            $folder = public_path().'/images/packs/';
            if(!file_exists($folder)){
                mkdir($folder, 0777, true);
                $file_logo->move(public_path().'/images/packs/',$fileLogo);
            }else{
                $file_logo->move(public_path().'/images/packs/',$fileLogo);
            }

            Session::flash('message', 'Paquete creado correctamente.');
            return Redirect::to('/packages');
        }else{
            Session::flash('message', 'Ocurrió un error al guardar.');
            return Redirect::to('/packages');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pack = Package::with('category')->where('id','=', $id)->first();
        return view('packs.show', compact('pack'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $isNew = true;
        $categories = Category::pluck('name','id');
        $pack = Package::with('category:id,name')->where('id','=', $id)->first();
        return view('packs.edit', compact('pack','categories', 'isNew'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $pack = Package::find($id);

        if(Input::hasFile('image')){
            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "packs" . "." . $ext;

            // Erase image if exists
            $image_path = $pack->image;
            if($image_path != '') {
                if (file_exists(public_path() . '/' . $image_path)) {
                    unlink(public_path() . '/' . $image_path);
                }
            }
            $file_logo->move(public_path().'/images/packs/',$fileLogo);
            $pack->image = 'images/packs/'.$fileLogo;
        }

        if(Input::hasFile('detail_image')){
            $file_logo = Input::file('detail_image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "__" . "packs" . "." . $ext;

            // Erase image if exists
            $image_path = $pack->detail_image;
            if($image_path != '') {
                if (file_exists(public_path() . '/' . $image_path)) {
                    unlink(public_path() . '/' . $image_path);
                }
            }
            $file_logo->move(public_path().'/images/packs/',$fileLogo);
            $pack->detail_image = 'images/packs/'.$fileLogo;
        }

        $pack->title = $request['title'];
        $pack->from = $request['from'];

        $pack->description = $request['description'];
        $pack->duration = $request['duration'];
        $pack->cities = $request['cities'];
        $pack->category_id = $request['category'];
        $pack->save();

        Session::flash('message','Paquete actualizado');
        return Redirect::to('/packages');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $pack = Package::find($id);
        $fileLogo = $pack->image;
        $fileLogo2 = $pack->detail_image;

        if(file_exists(public_path().'/'.$fileLogo))
            unlink(public_path().'/'.$fileLogo);

        if(file_exists(public_path().'/'.$fileLogo2))
            unlink(public_path().'/'.$fileLogo2);

        Package::destroy($id);
        Session::flash('message', 'Paquete eliminado correctamente.');
    }
    public function changestatuspromo(Request $request)
    {

        $id = $request['id'];
        $pack = Package::find($id);
        $pack->pack_status = $request ['status'] == 'true' ? 1:0;

        $pack-> update();
        Session::flash('message','Estatus actualizado');
      
    }
}
