@extends("layouts.master")
@section("styles")
    {!! Html::style("/assets/css/main.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css") !!}
@endsection

@section('breadcrumb')
    <div class="page-bar">
        @include('partials.request')
        <ul class="page-breadcrumb">
            <li>
                <a href="{!!URL::to('/')!!}">Inicio</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/banners')!!}">Banners</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a>Editar banner</a>
            </li>
        </ul>
    </div>
@endsection

@section("page-content")
    <div class="row content_container">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold">Editar banner</span>
                    </div>
                </div>
                <div class="portlet-body" style="padding-bottom: 60px;">
                    {!! Form::model($banner,['route' => ['banners.update', $banner->id], 'method' => 'PUT', 'files'=> true]) !!}
                    @include("banner.form")
                    {!!Form::close()!!}
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection

@section("scripts")
    {!! Html::script("/assets/scripts/validateFields.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js") !!}
    <script type="application/javascript">
        $(document).ready(function(){
            $("#liBan").addClass("active");
        });
    </script>
@endsection
