@extends("layouts.master")
@section("styles")
    {!! Html::style("/assets/css/main.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css") !!}
@endsection

@section('breadcrumb')
    <div class="page-bar">
        @include('partials.request')
        <ul class="page-breadcrumb">
            <li>
                <a href="{!!URL::to('/')!!}">Home</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/blog')!!}">Blog</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/blog/create')!!}">Nuevo Blog</a>
            </li>
        </ul>
    </div>
@endsection

@section("page-content")
    <div class="row content_container">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold">Nuevo blog</span>
                    </div>
                </div>
                <div class="portlet-body" style="padding-bottom: 60px;" >
                    {!! Form::open(['route' => 'blog.store', 'method' => 'POST', 'files'=> true]) !!}
                  {{--  <input type="hidden" name="_token" value="{{ csrf_token() }}" id="token">--}}
                    @include("blog.form")
                    {!!Form::close()!!}
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@section("scripts")
    {!! Html::script("/assets/scripts/validateFields.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js") !!}
    {!! Html::script("/assets/pages/scripts/components-editors.min.js") !!}
    <!-- <script src="{{ asset('/vendors/ckeditor/ckeditor.js') }}"></script> -->
    {!! Html::script('vendors/summernote/lang/summernote-es-ES.js') !!}

    <script type="application/javascript">
        $(document).ready(function(){
            $("#liBlo").addClass("active");

            $('#text').summernote({
            });
        });
        function check(e) {
    tecla = (document.all) ? e.keyCode : e.which;

    //Tecla de retroceso para borrar, siempre la permite
    if (tecla == 8) {
        return true;
    }

    // Patron de entrada, en este caso solo acepta numeros y letras
    patron = /[A-Za-z-._0-9á-úÁ-Ú]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}
    </script>
@endsection
