@extends("layouts.master")
@section("styles")
    {!! Html::style("/assets/css/main.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-select/css/bootstrap-select.min.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput-typeahead.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css") !!}
    {!! Html::style("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css") !!}
@endsection

@section('breadcrumb')
    <div class="page-bar">
        @include('partials.request')
        <ul class="page-breadcrumb">
            <li>
                <a href="{!!URL::to('/')!!}">Inicio</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/packages')!!}">Paquetes</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a>Editar paquete</a>
            </li>
        </ul>
    </div>
@endsection

@section("page-content")
    <div class="row content_container">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold">Editar paquete</span>
                    </div>
                </div>
                <div class="portlet-body" style="padding-bottom: 60px;">
                    {!! Form::model($pack,['route' => ['packages.update', $pack->id], 'method' => 'PUT', 'files'=> true]) !!}
                    @include("packs.form")
                    {!!Form::close()!!}
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection

@section("scripts")
    {!! Html::script("/assets/scripts/validateFields.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-select/js/bootstrap-select.min.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js") !!}
    {!! Html::script("/assets/global/plugins/typeahead/handlebars.min.js") !!}
    {!! Html::script("/assets/global/plugins/typeahead/typeahead.bundle.min.js") !!}
    {!! Html::script("/assets/pages/scripts/components-bootstrap-select.min.js") !!}
    {!! Html::script("/assets/pages/scripts/components-bootstrap-tagsinput.min.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js") !!}
    {!! Html::script("/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js") !!}
     {!! Html::script("/assets/pages/scripts/components-editors.min.js") !!}

    <script type="application/javascript">
        $(document).ready(function(){
            $("#liPack").addClass("active");

            $('.bootstrap-tagsinput input').keydown(function( event ) {
                if ( event.which == 13 ) {
                    $(this).blur();
                    $(this).focus();
                    return false;
                }
            });
        });
    </script>
@endsection
